/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.necklace;

import artifacts.common.capability.SwimHandler;
import artifacts.common.config.ModConfig;
import artifacts.common.item.curio.CurioItem;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import top.theillusivec4.curios.api.SlotContext;

public class CharmOfSinkingItem
extends CurioItem {
    public CharmOfSinkingItem() {
        this.addListener(EventPriority.HIGH, PlayerEvent.BreakSpeed.class, this::onBreakSpeed);
    }

    public void curioTick(SlotContext slotContext, ItemStack stack) {
        if (slotContext.entity().f_19797_ % 20 == 0 && slotContext.entity().m_204029_(FluidTags.f_13131_)) {
            this.damageStack(slotContext, stack);
        }
    }

    public void onBreakSpeed(PlayerEvent.BreakSpeed event, LivingEntity wearer) {
        if (wearer.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)wearer)) {
            event.setNewSpeed(event.getNewSpeed() * 5.0f);
        }
    }

    public void onEquip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        LivingEntity livingEntity;
        if (!ModConfig.server.isCosmetic(this) && (livingEntity = slotContext.entity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            slotContext.entity().getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                handler.setSinking(true);
                handler.syncSinking(player);
            });
        }
    }

    public void onUnequip(SlotContext slotContext, ItemStack originalStack, ItemStack newStack) {
        LivingEntity livingEntity = slotContext.entity();
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)livingEntity;
            slotContext.entity().getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                handler.setSinking(false);
                handler.syncSinking(player);
            });
        }
    }
}

